<?php
class NewsAdmin
{
  private $dbo = null;
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function checkNewsEditRights($newsId)
  {
    if(!$this->dbo) return false;
    
    $userId = $_SESSION['zalogowany_adm']->id;
    
    $query = "SELECT UserId FROM News "
           . "WHERE Id = $newsId AND UserId = $userId";
    
    return (bool) $this->dbo->getQuerySingleResult($query);
  }
  
  function showList($limit, $where)
  {
    if(!$this->dbo){
      echo 'Lista newsów nie jest dostępna.';
      return;
    }
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = (int) $_GET['page'];
    }
    else{
      $page = 0;
    }
    
    $userId = $_SESSION['zalogowany_adm']->id;
    
    //Określenie całkowitej liczby wierszy w tabeli News
    $query = "SELECT COUNT(*) FROM News WHERE UserId=$userId $where";
    $rowsCount = (int) $this->dbo->getQuerySingleResult($query);
    
    //Obliczenie całkowitej liczby stron z wynikami
    if($limit != 0){
      $pages = ceil($rowsCount / $limit);
    
      if($page < 0 || $page >= $pages) $page = 0;
    
      $offset = $page * $limit;
    }
    else{
      $page = 0;
      $pages = 1;
      $offset = 0;
      $limit = $rowsCount;
    }
    
    //Zapytanie pobierające wyniki dla bieżącej strony
    $query = "SELECT Id, Naglowek, Data "
           . "FROM News "
           . "WHERE UserId = $userId $where"
           . "LIMIT $offset, $limit";

    if(!$news = $this->dbo->query($query)){
      return;
    }
    
    include 'templates/newsList.php';
  }
  
  function showEditForm($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Edycja istniejącej wiadomości
    if($action == 'edit'){
      //Sprawdzenie czy istnieje parametr id
      if(!isset($_GET['id'])){
        echo 'Brak parametru id.';
        return FORM_DATA_MISSING;
      }
      
      //Sprawdzenie poprawności parametru id
      if(($id = (int)$_GET['id']) < 1){
        echo 'Nieprawidłowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Sprawdzenie uprawnień
      if(!$this->checkNewsEditRights($id)){
        echo 'Brak uprawnień.';
        return NOT_ENOUGH_RIGHTS;
      }
      
      //Zapytanie pobierające dane
      $query = "SELECT * FROM News WHERE Id=$id";
      
      if(!$result = $this->dbo->query($query)){
        echo 'Błąd serwera. Niewłaściwe zapytanie MySQL.';
        return SERVER_ERROR;
      }
      if(!$row = $result->fetch_row()){
        echo 'Nieprawidłowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Ustawienie wartości zmiennych używanych w formularzu
      $id = $row[0];
      $naglowek = $row[2];
      $tresc = $row[3];
      
      $wtd = 'modifyNews';
      $readonly = 'readonly="readonly"';
    }
    //Dodawanie nowej wiadomości
    else{
      $id = '';
      $naglowek = '';
      $tresc = '';
      $wtd = 'addNews';
      $readonly = '';
    }
    include 'templates/editNewsForm.php';
  }
  
  function editNews($action, &$id = 0)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane dane
    if(!isset($_POST['id']) || !isset($_POST['naglowek']) || 
       !isset($_POST['tresc']) ){
      return FORM_DATA_MISSING;
    }
    
    //Zapis danych w zmiennych pomocniczych
    $id = (int) $_POST['id'];
    $naglowek = filter_input(INPUT_POST, 'naglowek', 
      FILTER_SANITIZE_SPECIAL_CHARS);
    $tresc = filter_input(INPUT_POST, 'tresc', 
      FILTER_SANITIZE_SPECIAL_CHARS);
    
    //Sprawdzenie poprawności danych
    if(($action == 'edit' && $id < 1) || ($action == 'add' && $id < 0)){
      return INVALID_NEWS_ID;
    }
    
    /*
      Tutaj ewentualne dalsze instrukcje weryfikujące dane
    */
    
    //Zabezpieczenie znaków specjalnych w parametrach
    $naglowek = $this->dbo->real_escape_string($naglowek);
    $tresc = $this->dbo->real_escape_string($tresc);
    
    if($action == 'edit'){
      if(!$this->checkNewsEditRights($id)){
        return NOT_ENOUGH_RIGHTS;
      }
    
      $query = "UPDATE News SET Naglowek='$naglowek', Tresc='$tresc'"
             . "WHERE Id=$id ";
    }
    else{
      //Sprawdzenie czy istnieje news o podanym id
      if($id > 0){
        $query = "SELECT Id FROM News WHERE Id=$id";
        if($this->dbo->getQuerySingleResult($query) !== false){
          return NEWS_ID_ALREADY_EXISTS;
        }
      }
      
      //Formowanie zapytania
      $userId = $_SESSION['zalogowany_adm']->id;
      $query = "INSERT INTO News VALUES($id, $userId, '$naglowek', "
             . "'$tresc', NOW())";
    }
    
    if($this->dbo->query($query)){
      return ACTION_OK;
    }
    else{
      return ACTION_FAILED;
    }
  }
  
  function showSearchForm()
  {
    include 'templates/searchNewsForm.php';
  }
  
  function searchNews()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane dane
    if(!isset($_GET['id']) || !isset($_GET['naglowek'])){
      return FORM_DATA_MISSING;
    }
    
    $id = $_GET['id'];
    $naglowek = filter_input(INPUT_GET, 'naglowek', 
      FILTER_SANITIZE_SPECIAL_CHARS);
    
    if($id == '' && $naglowek == ''){
      return FORM_DATA_MISSING;
    }
    
    //Ustalenie warunku dla identyfikatora
    if($id != ''){
      $id = (int) $id;
      if($id < 1){
        return INVALID_USER_ID;
      }
      $cond1 = " AND id=$id ";
    }
    else{
      $cond1 = '';
    }
    
    //Ustalenie warunku dla nagłówka
    if($naglowek != ''){
      $naglowek = $this->dbo->real_escape_string($naglowek);
      $cond2 = " AND naglowek LIKE '%$naglowek%' ";
    }
    else{
      $cond2 = '';
    }
    
    $userId = $_SESSION['zalogowany_adm']->id;
    $cond3 = " AND userId = $userId ";
    
    $query = "SELECT COUNT(*) FROM News "
           . "WHERE 1=1 $cond1 $cond2 $cond3";
    $rowsCount = (int) $this->dbo->getQuerySingleResult($query);
    
    //Brak wyników
    if($rowsCount == 0){
      return NEWS_NOT_FOUND;
    }
    //Jeden wynik
    else if($rowsCount == 1){
      //Zapytanie pobierające dane
      $query = "SELECT id, naglowek, tresc FROM News "
             . "WHERE 1=1 $cond1 $cond2 $cond3";
      if(!$result = $this->dbo->query($query)){
        return SERVER_ERROR;
      }
      $row = $result->fetch_row();
    
      //Ustalenie stanu zmiennych dla formularza edycji danych
      $id = $row[0];
      $naglowek = $row[1];
      $tresc = $row[2];
    
      $readonly = '';
      $wtd = 'modifyNews';
    
      //Dołączenie formularza i powrót
      include 'templates/editNewsForm.php';
    }
    //Wiele wyników
    else{
      $this->showList(0, "$cond1 $cond2");
    }
    return ACTION_OK;
  }
  
  function deleteNews()
  {
    //Usunięcie wybranego wpisu
  }
}
?>